/* CssParser.java */
/* Generated By:JavaCC: Do not edit this line. CssParser.java */
package org.w3c.css.parser.analyzer;

import org.w3c.css.media.AtRuleMedia;
import org.w3c.css.media.MediaFeature;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRuleCounterStyle;
import org.w3c.css.parser.AtRuleFontFace;
import org.w3c.css.parser.AtRuleKeyframes;
import org.w3c.css.parser.AtRulePage;
import org.w3c.css.parser.AtRulePhoneticAlphabet;
import org.w3c.css.parser.AtRulePreference;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.svg.AtRuleColorProfile;
import org.w3c.css.selectors.AdjacentSiblingSelector;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.ChildSelector;
import org.w3c.css.selectors.ClassSelector;
import org.w3c.css.selectors.DescendantSelector;
import org.w3c.css.selectors.GeneralSiblingSelector;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.UniversalSelector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.selectors.attributes.AttributeSubstr;
import org.w3c.css.selectors.attributes.AttributeSuffix;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.util.WarningParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssAttr;
import org.w3c.css.values.CssBracket;
import org.w3c.css.values.CssCalc;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFlexibleLength;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssHashIdent;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssImage;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssRatio;
import org.w3c.css.values.CssResolution;
import org.w3c.css.values.CssSemitone;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssSwitch;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssTypes;
import org.w3c.css.values.CssURL;
import org.w3c.css.values.CssUnicodeRange;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssVolume;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;

/**
 * A CSS parser  
 *
 * @author Philippe Le Hegaret, Sijtsche Smeman, Yves Lafon
 */
public abstract class CssParser implements CssParserConstants {

    private static char hexdigits[] = { '0', '1', '2', '3',
                                        '4', '5', '6', '7',
                                        '8', '9', 'a', 'b',
                                        'c', 'd', 'e', 'f' };
    // the current atRule
    protected AtRule atRule;
    protected boolean mediaDeclaration = false;

    /**
     * The URL of the document
     */
    protected URL url;

    protected ApplContext ac;

    protected boolean incompatible_error;

    /**
     * The current context recognized by the parser (for errors).
     */
    protected ArrayList<CssSelectors> currentContext;

    /**
     * The current property recognized by the parser (for errors).
     */
    protected String currentProperty;

    /**
     * <code>true</code> if the parser should recognized Aural properties, 
     * <code>false</code> otherwise.
     */
    protected boolean mode;

    /**
     * <code>true</code> if the parser had recognize a rule,
     * <code>false</code> otherwise.
     */
    protected boolean markRule;

    private boolean reinited = false;
    private boolean charsetdeclared = false;

    // to be able to remove a ruleset if the selector is not valid
    protected boolean validSelector = true;

    /**
     * The ac for handling errors and warnings.
     * 
     * @param ac the new ac for the parser.
     */
    public final void setApplContext(ApplContext ac) {
        this.ac = ac;
    }

    /**
     * Set the attribute atRule
     *
     * @param atRule the new value for the attribute
     */
    public void setAtRule(AtRule atRule) {
        this.atRule = atRule;
    }

    /**
     * Set the attribute mediaDeclaration
     *
     * @param mediadeclaration indicator if in a media expression list or not
     */
    public void setMediaDeclaration(boolean mediadeclaration) {
        this.mediaDeclaration = mediadeclaration;
    }

    /**
     * Returns the attribute mediaDeclaration
     *
     * @return the value of the attribute
     */
    public boolean hasMediaDeclaration() {
        return mediaDeclaration;
    }

    /**
     * Returns the attribute atRule
     *
     * @return the value of the attribute
     */
    public AtRule getAtRule() {
        return atRule;
    }

    /**
     * Reinitialized the parser.
     *
     * @param stream the stream data to parse.
     * @param ac  the new ac to use for parsing.
     */
    public void ReInitWithAc(InputStream stream, ApplContext ac,
                             String charset)
    {
        InputStream is = /*new  CommentSkipperInputStream(stream);*/stream;
        if (charset == null) {
            charset = "iso-8859-1";
        }
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, charset);
        } catch (UnsupportedEncodingException uex) {
            isr = new InputStreamReader(is);
        }
        // reinit, it can not happen...
        // ...in theory ;)
        ReInit(isr);
        markRule = false;
        reinited = true;
        setApplContext(ac);
    }

    /* utilities for a parser */

    /**
     * Call by the import statement.
     *
     * @param url  The style sheet where this import statement appears.
     * @param file the file name in the import
     */
    public abstract void handleImport(URL url, String file,
                                      boolean is_url, AtRuleMedia media);

    /**
     * Call by the namespace declaration statement.
     *
     * @param url  The style sheet where this namespace statement appears.
     * @param file the file/url name in the namespace declaration
     */
    public abstract void handleNamespaceDeclaration(URL url, String prefix,
                                                    String file,
                                                    boolean is_url);

    /**
     * Call by the at-rule statement.
     *
     * @param ident  The ident for this at-rule (for example: 'font-face')
     * @param string The string associate to this at-rule
     * @see          org.w3c.css.parser.analyzer.Couple
     */
    public abstract void handleAtRule(String ident, String string);

    /* added by Sijtsche Smeman */
    public abstract void addCharSet(String charset);
    public abstract void newAtRule(AtRule atRule);
    public abstract void endOfAtRule();
    public abstract void setImportant(boolean important);
    public abstract void setSelectorList(ArrayList<CssSelectors> selectors);
    public abstract void addProperty(ArrayList<CssProperty> properties);
    public abstract void endOfRule();
    public abstract void removeThisRule();
    public abstract void removeThisAtRule();

    /**
     * Assign an expression to a property.  This function create a new property
     * with <code>property</code> and assign to it the expression with the
     * importance. Don't forget to set informations too.
     * <p>
     * A subclass must provide an implementation of this method. 
     *
     * @param  property  the name of the property
     * @param  values    the expression representation of values
     * @param  important <code>true</code> if values are important
     *
     * @return           <code>null</code>or a property
     * 
     * @see              org.w3c.css.properties.css.CssProperty
     */
    public abstract CssProperty handleDeclaration(String property,
                                                  CssExpression values,
                                                  boolean important)
        throws InvalidParamException;

    /**
     * Assign an expression to a mediafeature.
     * This function create a new mediafeature
     * with <code>mediaFeature</code> and assign to it the expression.
     * <p>
     * A subclass must provide an implementation of this method.
     *
     * @param  mediaFeature  the name of the media feature
     * @param  expr          the expression representation of values
     *
     * @return           <code>null</code>or a property
     *
     * @see              org.w3c.css.properties.css.CssProperty
     */
    public abstract MediaFeature handleMediaFeature(AtRuleMedia rule,
                                                    String mediaFeature,
                                                                            CssExpression expr)
               throws InvalidParamException;



    /**
     * Adds a ArrayList of properties to a selector.
     * <p>
     * A subclass must provide an implementation of this method. 
     *
     * @param selector     the selector
     * @param declarations Properties to associate with contexts
     */
    public abstract void handleRule(CssSelectors selector,
                                    ArrayList<CssProperty> declarations);

    /*Added by Sijtsche Smeman */

    /**
     * Returns the source file of the style sheet
     */
    public final String getSourceFile() {
        return getURL().toString();
    }

    /**
     * Returns the current line in the style sheet
     */
    public final int getLine() {
        //return token.beginLine;
        return 0;
    }

    /**
     * Set the URL of the style sheet.
     *
     * @param url The URL for the style sheet
     */
    public final void setURL(URL url) {
        this.url = url;
    }

    public final URL getURL() {
        return url;
    }

    /**
     * Return the next selector from the inputstream
     */
    public CssSelectors parseSelector() throws ParseException {
            return externalSelector();
    }

    /**
     * Return the next @media rule from the inputstream
     */
    public AtRuleMedia parseMediaDeclaration()  throws ParseException {
        AtRuleMedia newRule = AtRuleMedia.getInstance(ac.getCssVersion());
            mediaquerylist(newRule);
            return newRule;
    }
    /*
     * Add a value to an expression
     */
    private void setValue(CssValue v, CssExpression expr,
                          char operator, Token n, int token)
        throws ParseException {

        if ( token == FUNCTION ) {
            if ( v.getType() == CssTypes.CSS_FUNCTION ) {
                CssFunction f = (CssFunction) v;
                if (f.getParameters().hasVendorExtensions()) {
                    expr.markVendorExtension();
                }
            }
        }
        if (n != null) {
            if (ac.getCssVersion() == CssVersion.CSS1 &&
                                          (n.image).equals("inherit")) {
                    incompatible_error = true;
            }
            String val = addOperator(operator, n.image);

            if (n.kind == CssParserConstants.IDENT) {
                String s = convertIdent(val);
            if ('-' == s.charAt(0)) {
                expr.markVendorExtension();
            }
                    v.set(convertIdent(val), ac);
            } else if (n.kind == CssParserConstants.STRING) {
                    v.set(val, ac);
            } else {
                    v.set(val, ac);
            }
        }
        expr.addValue(v);
    }

    /*
     * Error control
     */
    private void addError(Exception e, String skippedText) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setSkippedString(skippedText);
        ex.setProperty(currentProperty);
        ex.setContexts(currentContext);
        CssError error = new CssError(getSourceFile(), getLine(), ex);
        ac.getFrame().addError(error);
    }

    /*
     * Error control 2
     */
    private void addError(Exception e, CssExpression exp) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }

        //	if ((exp != null) && (exp.getCount() != 0)) {
        CssParseException ex = new CssParseException(e);
        ex.setExp(exp);
        ex.setProperty(currentProperty);
        ex.setContexts(currentContext);
        CssError error = new CssError(getSourceFile(), getLine(), ex);
        ac.getFrame().addError(error);
        //	}
    }

    private void addParseError(ParseException e, String skipped) {
          if (Util.onDebug) {
              System.err.println(e.getMessage());
              e.printStackTrace();
          }
          CssErrorToken err = new CssErrorToken(e, skipped);
          ac.getFrame().addError(err);
    }

    private static String addOperator(char operator, String value) {
        return (' ' == operator) ? value : operator+value;
    }

//<DEFAULT, IN_COMMENT>
//TOKEN :
//{ /* avoid token manager error */
//   < UNKNOWN : ~[] >
//}

/*
 * The grammar of CSS2
 */

/**
 * The main entry for the parser.
 *
 * @exception ParseException exception during the parse
 */
  final public void parserUnit() throws ParseException {Token n = null;
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HTMLSTARTTAG:
        case HTMLENDTAG:{
          ;
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HTMLSTARTTAG:{
          n = jj_consume_token(HTMLSTARTTAG);
          break;
          }
        case HTMLENDTAG:{
          n = jj_consume_token(HTMLENDTAG);
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
addError (new ParseException(ac.getMsg().getString("generator.dontmixhtml")), n.image);
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CHARSET_SYM:{
          ;
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        charset();
      }
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case CDO:
        case CDC:{
          ;
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        case CDO:{
          jj_consume_token(CDO);
          break;
          }
        case CDC:{
          jj_consume_token(CDC);
          break;
          }
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORT_SYM:{
          ;
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          break label_4;
        }
        importDeclaration();
        ignoreStatement();
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NAMESPACE_SYM:{
          ;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          break label_5;
        }
        namespaceDeclaration();
        ignoreStatement();
      }
      afterImportDeclaration();
      jj_consume_token(0);
    } catch (TokenMgrError err) {
addError (new ParseException(ac.getMsg().getString("generator.unrecognize")),
            err.getMessage());
    }
  }

  final public void charset() throws ParseException {Token n = null;
    Token charsetToken = null;
    Token space1Token = null;
    Token space2Token = null;
    Token semicolonToken = null;
    int nb_S = 0;
    CssVersion version = ac.getCssVersion();
    try {
      charsetToken = jj_consume_token(CHARSET_SYM);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          break label_6;
        }
        space1Token = jj_consume_token(S);
nb_S++;
      }
      n = jj_consume_token(STRING);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[8] = jj_gen;
          break label_7;
        }
        space2Token = jj_consume_token(S);
      }
      semicolonToken = jj_consume_token(SEMICOLON);
if (charsetdeclared && !reinited) {
                    {if (true) throw new ParseException(
                                     ac.getMsg().getString("parser.charset"));}
                }
                // the @charset must be at the beginning of the document
                if(charsetToken.beginLine != 1 ||
                   charsetToken.beginColumn != 1) {
                    {if (true) throw new ParseException(
                                  ac.getMsg().getString("parser.charset"));}
                }
                if (version == CssVersion.CSS1) {
                    {if (true) throw new ParseException(ac.getMsg().getString(
                                                         "parser.charsetcss1"));}
                }
                // stricter rule for CSS21 and soon for CSS3
                // if equal of above CSS21
                if (version.compareTo(CssVersion.CSS21) >= 0) {
                    // single space before
                    // case sensitive
                    // no space before ;
                    // no comments
                    // string must start with "
                    if ( (nb_S != 1) ||
                         (!"@charset".equals(charsetToken.image)) ||
                         (!" ".equals(space1Token.image)) ||
                         (space2Token != null &&
                          !"".equals(space2Token.image)) ||
                         (space1Token.specialToken != null) ||
                         (n.specialToken != null) ||
                         (semicolonToken.specialToken != null) ||
                         (n.image.charAt(0) != '\"')
                        ) {
                        {if (true) throw new ParseException(ac.getMsg().getString(
                                                     "parser.charsetspecial"));}
                    }
                }
                if (!charsetdeclared) {
                    addCharSet(n.image.substring(1, n.image.length()-1));
                    charsetdeclared = true;
                } else {
                    reinited = false;
                }
    } catch (Exception e) {
String skip = charsetToken +
            ((space1Token == null) ? "" : space1Token.image) +
            n +
            ((space2Token == null) ? "" : space2Token.image) +
            ";";
        addError(e, skip);
    }
  }

  final public void afterImportDeclaration() throws ParseException {String ret;
    label_8:
    while (true) {
      ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case HASHIDENT:
      case HASH:
      case LBRACKET:
      case ANY:
      case COLON:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case ANGLE:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN:
      case PSEUDOELEMENT_SYM:
      case CLASS:
      case FUNCTIONNOT:
      case 104:{
        ruleSet();
        break;
        }
      case MEDIA_SYM:{
        media();
        break;
        }
      case PAGE_SYM:{
        page();
        break;
        }
      case FONT_FACE_SYM:{
        fontFace();
        break;
        }
      case KEYFRAMES_SYM:{
        keyframes();
        break;
        }
      case PREF_SYM:{
        preference();
        break;
        }
      case COLOR_PROFILE:{
        colorprofile();
        break;
        }
      case COUNTER_STYLE_SYM:{
        counterstyle();
        break;
        }
      case PHONETIC_ALPHABET_SYM:{
        phoneticAlphabet();
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        ret = skipStatement();
if ((ret == null) || (ret.length() == 0)) {
                {if ("" != null) return;}
            }
          // quite ugly but necessary to avoid probably a lot of changes in the
          // grammar, still having a beautiful error message
            else if (ret.startsWith("@charset")) {
                ParseException e =
                new ParseException(ac.getMsg().getString("parser.charset"));
                addError(e, ret);
            } else if (ret.startsWith("@import")) {
                ParseException e =
                new ParseException(ac.getMsg().getString("parser.import_not_allowed"));
                addError(e, ret);
            } else {
                ParseException e =
             new ParseException(ac.getMsg().getString("generator.unrecognize"));
                addError(e, ret);
            }
      }
      ignoreStatement();
    }
  }

  final public void ignoreStatement() throws ParseException {
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CDO:
      case CDC:
      case ATKEYWORD:{
        ;
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CDO:{
        jj_consume_token(CDO);
        break;
        }
      case CDC:{
        jj_consume_token(CDC);
        break;
        }
      case ATKEYWORD:{
        atRuleDeclaration();
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
    }
  }

  final public void namespaceDeclaration() throws ParseException {Token n=null;
    Token v=null;
    boolean is_url; /* for formatting */
    String nsname;
    String prefix = null;
    CssValue val;
    jj_consume_token(NAMESPACE_SYM);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_11;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      n = jj_consume_token(IDENT);
prefix = convertIdent(n.image);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[14] = jj_gen;
          break label_12;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING:{
      v = jj_consume_token(STRING);
is_url = false;
              nsname = v.image.substring(1, v.image.length()-1);
      break;
      }
    case URL:{
      v = jj_consume_token(URL);
is_url = true;
              val = new CssURL();
              ((CssURL) val).set(v.image, ac, url);
              nsname = (String) val.get();
              if ((nsname.charAt(0) == '"')
                  || (nsname.charAt(0) == '\'')) {
                  nsname = nsname.substring(1, nsname.length()-1);
              }
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_13;
      }
      jj_consume_token(S);
    }
    jj_consume_token(SEMICOLON);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        break label_14;
      }
      jj_consume_token(S);
    }
// If less than CSS 3
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            addError(new InvalidParamException("at-rule", "@namespace", ac),
                     (n==null)?"default":n.toString());
        } else {
            if (v != null) {
                handleNamespaceDeclaration(getURL(), prefix, nsname, is_url);
            }
        }
  }

/**
 * The import statement
 *
 * @exception ParseException exception during the parse
 */
  final public void importDeclaration() throws ParseException {Token n;
    AtRuleMedia media = AtRuleMedia.getInstance(ac.getCssVersion());
    CssValue val;
    String importFile;
    boolean is_url = false;
    try {
      jj_consume_token(IMPORT_SYM);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[19] = jj_gen;
          break label_15;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        n = jj_consume_token(STRING);
importFile = n.image.substring(1, n.image.length() -1);
                is_url = false;
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
val = new CssURL();
                ((CssURL) val).set(n.image, ac, url);
                importFile = (String) val.get();
                if ((importFile.charAt(0) == '"')
                    || (importFile.charAt(0) == '\'')) {
                    importFile = importFile.substring(1, importFile.length()-1);
                }
                is_url = true;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          break label_16;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MEDIARESTRICTOR:
      case IDENT:
      case RPARAN:{
        mediaquerylist(media);
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          break label_17;
        }
        jj_consume_token(S);
      }
handleImport(getURL(), importFile, is_url, media);
    } catch (ParseException e) {
addError(e, skipStatement());
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public AtRuleMedia media() throws ParseException {AtRule old = getAtRule();
    AtRuleMedia newRule = AtRuleMedia.getInstance(ac.getCssVersion());
    setAtRule(newRule);
    Token n;
    CssProperty p = null;
    boolean isCss1 =  (ac.getCssVersion() == CssVersion.CSS1);
    try {
      n = jj_consume_token(MEDIA_SYM);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          break label_18;
        }
        jj_consume_token(S);
      }
      mediaquerylist(newRule);
String media = getAtRule().toString();
                    if (ac.getMedium() != null &&
                        !(media.equals(ac.getMedium())) &&
                        !(ac.getMedium().equals("all"))) {

                        ac.getFrame().addWarning("noothermedium", getAtRule().toString());
                    }
                    if (isCss1) {
                        skipStatement();
                        addError(new InvalidParamException("noatruleyet", "", ac),
                                 getAtRule().toString());
                    } else {
                        newAtRule(getAtRule());
                    }
      jj_consume_token(LBRACE);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case ANY:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case CLASS:
        case FUNCTIONNOT:
        case 104:{
          ;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          break label_20;
        }
        ruleSet();
      }
      jj_consume_token(RBRACE);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          break label_21;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                         endOfAtRule();
                     }
    } catch (ParseException e) {
if (!isCss1) {
                addError(e, skipStatement());
            }
            newRule = null;
    } finally {
setAtRule(old);
            {if ("" != null) return newRule;}
    }
    throw new Error("Missing return statement in function");
  }

  final public void ratio(CssExpression exp, char operator) throws ParseException {Token w,h,n;
    w = jj_consume_token(NUMBER);
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_22;
      }
      jj_consume_token(S);
    }
    jj_consume_token(DIV);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_23;
      }
      jj_consume_token(S);
    }
    h = jj_consume_token(NUMBER);
StringBuilder sb = new StringBuilder();
     sb.append(w.image).append('/').append(h.image);
     n = Token.newToken(w.kind, sb.toString());
     setValue(new CssRatio(), exp, operator, n, NUMBER);
  }

  final public void mediaquerylist(AtRuleMedia mediaRule) throws ParseException {CssVersion v = ac.getCssVersion();
  boolean isCss1 =  (v == CssVersion.CSS1);
    mediaquery(mediaRule);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_24;
      }
      jj_consume_token(COMMA);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_25;
        }
        jj_consume_token(S);
      }
      mediaquery(mediaRule);
    }
  }

  final public void mediaquery(AtRuleMedia mediaRule) throws ParseException {CssVersion v = ac.getCssVersion();
  boolean isCss1 =  (v == CssVersion.CSS1);
  Token n;
  String mediarestrictor = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MEDIARESTRICTOR:
    case IDENT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MEDIARESTRICTOR:{
        n = jj_consume_token(MEDIARESTRICTOR);
mediarestrictor = convertIdent(n.image);
        label_26:
        while (true) {
          jj_consume_token(S);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[32] = jj_gen;
            break label_26;
          }
        }
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        ;
      }
      n = jj_consume_token(IDENT);
mediaRule.addMedia(mediarestrictor, convertIdent(n.image), ac);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          break label_27;
        }
        jj_consume_token(S);
      }
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          ;
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          break label_28;
        }
        jj_consume_token(AND);
        label_29:
        while (true) {
          jj_consume_token(S);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[36] = jj_gen;
            break label_29;
          }
        }
        mediaexpression(mediaRule, false);
      }
      break;
      }
    case RPARAN:{
      mediaexpression(mediaRule, true);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          ;
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_30;
        }
        jj_consume_token(AND);
        label_31:
        while (true) {
          jj_consume_token(S);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[38] = jj_gen;
            break label_31;
          }
        }
        mediaexpression(mediaRule, false);
      }
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }

  }

  final public void mediaexpression(AtRuleMedia mediaRule, boolean defaultMedia) throws ParseException {CssVersion v = ac.getCssVersion();
  boolean isCss1 =  (v == CssVersion.CSS1);
  CssExpression val = null;
  String mediaFeatureName = null;
  Token n;
    jj_consume_token(RPARAN);
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        break label_32;
      }
      jj_consume_token(S);
    }
    n = jj_consume_token(IDENT);
// here we add the default media if not present
       if (defaultMedia) {
           mediaRule.addMedia(null, null, ac);
       }
       mediaFeatureName = convertIdent(n.image);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        break label_33;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[42] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
      val = mediaexpr();
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    jj_consume_token(LPARAN);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_35;
      }
      jj_consume_token(S);
    }
MediaFeature mf = handleMediaFeature(mediaRule, mediaFeatureName, val);
        mediaRule.addMediaFeature(mf, ac);
  }

  final public void unused_production_generic_syntax() throws ParseException {CssExpression values = new CssExpression();
    jj_consume_token(RPARAN);
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        break label_36;
      }
      jj_consume_token(S);
    }
    term(values);
    jj_consume_token(LPARAN);

  }

  final public void unused_production_definition() throws ParseException {CssExpression values = new CssExpression();
    jj_consume_token(LBRACKET);
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        break label_37;
      }
      jj_consume_token(S);
    }
    term(values);
    jj_consume_token(RBRACKET);

  }

/**
 * @exception ParseException exception during the parse
 */
  final public void page() throws ParseException {ArrayList<CssProperty> v                              ;
    Token        n        = null                ;
    ArrayList<CssProperty>       collectv = new ArrayList<CssProperty>()        ;
    CssSelectors s        = new CssSelectors(ac);
    AtRule       old      = getAtRule()         ;
    AtRulePage   newRule  = new AtRulePage()    ;
    setAtRule(newRule);
    s.setAtRule(getAtRule());
    boolean isCss1 = (ac.getCssVersion() == CssVersion.CSS1);
    try {
      jj_consume_token(PAGE_SYM);
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[47] = jj_gen;
          break label_38;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        n = jj_consume_token(IDENT);
newRule.setIdent(convertIdent(n.image));
        label_39:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[48] = jj_gen;
            break label_39;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        pseudo_page(newRule);
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          break label_40;
        }
        jj_consume_token(S);
      }
      v = pageContent();
collectv = v;
      jj_consume_token(RBRACE);
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          break label_41;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                    newAtRule(getAtRule());
                    addProperty(collectv);
                    endOfRule();
                    endOfAtRule();
                }
                if (v == null) {
                    ac.getFrame().addWarning("no-declaration");
                } else {
                    handleRule(s, collectv);
                }
    } catch (InvalidParamException ie) {
if (!isCss1) {
            skipStatement();
            removeThisAtRule();
            ac.getFrame().addError(new CssError(ie));
        }
    } catch (ParseException e) {
if (!isCss1) {
            removeThisAtRule();
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public ArrayList<CssProperty> pageContent() throws ParseException {CssProperty prop;
    ArrayList<CssProperty> v = new ArrayList<CssProperty>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ATTOP:
    case ATRIGHT:
    case ATBOTTOM:
    case ATLEFT:{
      // <CSS3> ?? FIXME
          v = prefAtRule();
{if ("" != null) return v;}
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      v = declarations();
{if ("" != null) return v;}
    }
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<CssProperty> prefAtRule() throws ParseException {Token n;
    ArrayList<CssProperty> v;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ATTOP:{
        n = jj_consume_token(ATTOP);
        break;
        }
      case ATBOTTOM:{
        n = jj_consume_token(ATBOTTOM);
        break;
        }
      case ATLEFT:{
        n = jj_consume_token(ATLEFT);
        break;
        }
      case ATRIGHT:{
        n = jj_consume_token(ATRIGHT);
        break;
        }
      default:
        jj_la1[54] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_42;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_43:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[56] = jj_gen;
          break label_43;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_44:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[57] = jj_gen;
          break label_44;
        }
        jj_consume_token(S);
      }
{if ("" != null) return v;}
    } catch (ParseException e) {
addError(e, skipStatement());
    }
    throw new Error("Missing return statement in function");
  }

  final public void pseudo_page(AtRulePage page) throws ParseException {Token n;
    jj_consume_token(COLON);
    n = jj_consume_token(IDENT);
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        break label_45;
      }
      jj_consume_token(S);
    }
try {
            page.setName(":" + convertIdent(n.image), ac);
        } catch (InvalidParamException e) {
            {if (true) throw new InvalidParamException("pseudo", n.image, ac );}
            /*CssError error = new CssError(getSourceFile(), getLine(), e);
	      ac.getFrame().addError(error);	*/
        }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssSelectors keyframe_selector(CssSelectors next) throws ParseException {CssSelectors selector = new CssSelectors(ac, next);
    selector.setAtRule(getAtRule());
    Token n;
    Token op = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        n = jj_consume_token(IDENT);
CssIdent ident = new CssIdent();
      ident.set(convertIdent(n.image), ac);
      AtRuleKeyframes.checkSelectorValue(ident, ac);
      selector.addType(new TypeSelector(ident.toString()));
        break;
        }
      case PLUS:
      case MINUS:
      case PERCENTAGE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PLUS:{
            op = jj_consume_token(PLUS);
            break;
            }
          case MINUS:{
            op = jj_consume_token(MINUS);
            break;
            }
          default:
            jj_la1[59] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[60] = jj_gen;
          ;
        }
        n = jj_consume_token(PERCENTAGE);
CssPercentage p = new CssPercentage();
      if (op == null) {
        p.set(n.image, ac);
      } else {
        p.set(op.image+n.image, ac);
      }
      AtRuleKeyframes.checkSelectorValue(p, ac);
      selector.addType(new TypeSelector(n.image));
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[62] = jj_gen;
          break label_46;
        }
        jj_consume_token(S);
      }
{if ("" != null) return selector;}
    } catch (InvalidParamException ie) {
ac.getFrame().addError(new CssError(ie));
        Token t = getToken(1);
        StringBuilder s = new StringBuilder();
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        {if ("" != null) return null;}
    } catch (ParseException e) {
// TODO fix the error
        Token t = getToken(1);
        int _line = t.beginLine;
        int _col  = t.beginColumn;
        StringBuilder s = new StringBuilder();
        s.append(" [");
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        s.append(']');
        addParseError(e, s.toString());
        validSelector = true;
        {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

  final public void keyframes() throws ParseException {Token n;
  ArrayList<CssProperty> v;
  AtRule old = getAtRule();
  AtRuleKeyframes krule = new AtRuleKeyframes("-internal-");
  setAtRule(krule);
  CssSelectors s;
  ArrayList<CssSelectors> sl;
  CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(KEYFRAMES_SYM);
      label_47:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[63] = jj_gen;
          break label_47;
        }
      }
      n = jj_consume_token(IDENT);
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[64] = jj_gen;
          break label_48;
        }
        jj_consume_token(S);
      }
krule.setName(convertIdent(n.image));
      if (version.compareTo(CssVersion.CSS3) < 0) {
        skipStatement();
        addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
      } else {
        newAtRule(getAtRule());
      }
      jj_consume_token(LBRACE);
      label_49:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          break label_49;
        }
        jj_consume_token(S);
      }
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:
        case IDENT:
        case PERCENTAGE:{
          ;
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          break label_50;
        }
        s = keyframe_selector(null);
sl = new ArrayList<CssSelectors>();
        if (s != null) {
          s.setAtRule(getAtRule());
          sl.add(s);
        }
        label_51:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[67] = jj_gen;
            break label_51;
          }
          jj_consume_token(COMMA);
          label_52:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[68] = jj_gen;
              break label_52;
            }
            jj_consume_token(S);
          }
          s = keyframe_selector(null);
if (s != null) {
         s.setAtRule(getAtRule());
         sl.add(s);
       }
        }
        jj_consume_token(LBRACE);
        label_53:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[69] = jj_gen;
            break label_53;
          }
          jj_consume_token(S);
        }
        v = declarations();
        jj_consume_token(RBRACE);
        label_54:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[70] = jj_gen;
            break label_54;
          }
          jj_consume_token(S);
        }
validSelector = (sl.size() != 0);
        if (validSelector) {
          if (v == null) {
            ac.getFrame().addWarning("no-declaration");
          } else {
            boolean first = true;
            for (CssSelectors _s : sl) {
              if (first) {
                 handleRule(_s, v);
                 first = false;
              } else {
                 ArrayList<CssProperty> vcopy = new ArrayList<CssProperty>(v.size());
                 for (CssProperty p : v) {
                   vcopy.add(p.duplicate());
                 }
                 handleRule(_s, vcopy);
              }
            }
          }
          setSelectorList(sl);
          endOfRule();
        }
      }
      jj_consume_token(RBRACE);
      label_55:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[71] = jj_gen;
          break label_55;
        }
        jj_consume_token(S);
      }
endOfAtRule();
    } catch (ParseException e) {
addError(e, skipStatement());
    } finally {
setAtRule(old);
    }
  }

  final public void fontFace() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRuleFontFace());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    boolean isCss1 = (ac.getCssVersion() == CssVersion.CSS1);
    try {
      jj_consume_token(FONT_FACE_SYM);
      label_56:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[72] = jj_gen;
          break label_56;
        }
        jj_consume_token(S);
      }
if (isCss1) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_57:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[73] = jj_gen;
          break label_57;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_58:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[74] = jj_gen;
          break label_58;
        }
        jj_consume_token(S);
      }
if (!isCss1) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }
                 if (v == null) {
                     ac.getFrame().addWarning("no-declaration");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (!isCss1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void colorprofile() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRuleColorProfile());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    CssProfile profile = ac.getCssProfile();
    boolean isSVG = ((profile == CssProfile.SVG) ||
                     (profile == CssProfile.SVGBASIC) ||
                     (profile == CssProfile.SVGTINY));
    try {
      jj_consume_token(COLOR_PROFILE);
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[75] = jj_gen;
          break label_59;
        }
        jj_consume_token(S);
      }
if (!isSVG) {
                    skipStatement();
                    addError(new InvalidParamException("onlysvg", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_60:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[76] = jj_gen;
          break label_60;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_61:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[77] = jj_gen;
          break label_61;
        }
        jj_consume_token(S);
      }
if (isSVG) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }

                 if (v == null) {
                     //ac.getFrame().addWarning("medialist");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (isSVG) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void counterstyle() throws ParseException {Token n;
  ArrayList<CssProperty> v;
  AtRule old = getAtRule();
  AtRuleCounterStyle csrule = new AtRuleCounterStyle();
  setAtRule(csrule);
  CssSelectors s = new CssSelectors(ac);;
  CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(COUNTER_STYLE_SYM);
      label_62:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[78] = jj_gen;
          break label_62;
        }
      }
      n = jj_consume_token(IDENT);
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[79] = jj_gen;
          break label_63;
        }
        jj_consume_token(S);
      }
csrule.setName(convertIdent(n.image));
      if (version.compareTo(CssVersion.CSS3) < 0) {
        skipStatement();
        addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
      } else {
        newAtRule(getAtRule());
      }
      jj_consume_token(LBRACE);
      label_64:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[80] = jj_gen;
          break label_64;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_65:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          break label_65;
        }
        jj_consume_token(S);
      }
if (version.compareTo(CssVersion.CSS3) >= 0) {
            addProperty(v);
            endOfRule();
            endOfAtRule();
         }
         if (v == null) {
            ac.getFrame().addWarning("no-declaration");
         } else {
            handleRule(s, v);
         }
    } catch (ParseException e) {
addError(e, skipStatement());
    } finally {
setAtRule(old);
    }
  }

  final public void preference() throws ParseException {ArrayList<CssProperty> v;
    AtRule old = getAtRule();
    setAtRule(new AtRulePreference());
    CssSelectors s = new CssSelectors(ac);
    s.setAtRule(getAtRule());
    boolean isCSS1 = (ac.getCssVersion() == CssVersion.CSS1);
    try {
      jj_consume_token(PREF_SYM);
      label_66:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[82] = jj_gen;
          break label_66;
        }
        jj_consume_token(S);
      }
if (isCSS1) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                } else {
                    newAtRule(getAtRule());
                }
      jj_consume_token(LBRACE);
      label_67:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[83] = jj_gen;
          break label_67;
        }
        jj_consume_token(S);
      }
      v = declarations();
      jj_consume_token(RBRACE);
      label_68:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[84] = jj_gen;
          break label_68;
        }
        jj_consume_token(S);
      }
if (!isCSS1) {
                     addProperty(v);
                     endOfRule();
                     endOfAtRule();
                 }

                 if (v == null) {
                     ac.getFrame().addWarning("medialist");
                 } else {
                     handleRule(s, v);
                 }
    } catch (ParseException e) {
if (!isCSS1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

  final public void phoneticAlphabet() throws ParseException {AtRule old = getAtRule();
    AtRulePhoneticAlphabet alphabetrule = new AtRulePhoneticAlphabet();
    setAtRule(alphabetrule);
    Token n;
    CssVersion version = ac.getCssVersion();
    try {
      jj_consume_token(PHONETIC_ALPHABET_SYM);
      label_69:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          break label_69;
        }
        jj_consume_token(S);
      }
      n = jj_consume_token(STRING);
      label_70:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[86] = jj_gen;
          break label_70;
        }
        jj_consume_token(S);
      }
      jj_consume_token(SEMICOLON);
// FIXME comparison > CSS3
                if (version.compareTo(CssVersion.CSS3) < 0) {
                    skipStatement();
                    addError(new InvalidParamException("noatruleyet", "", ac),
                             getAtRule().toString());
                }

                alphabetrule.addAlphabet(convertIdent(n.image), ac);

                if ((version != CssVersion.CSS1) && (version != CssVersion.CSS2)) {
                    newAtRule(getAtRule());
                }
    } catch (ParseException e) {
if (version != CssVersion.CSS1) {
            addError(e, skipStatement());
        }
    } finally {
setAtRule(old);
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void atRuleDeclaration() throws ParseException {Token n;
    n = jj_consume_token(ATKEYWORD);
//ac.getFrame().addWarning("at-rule", token.toString());
            ac.getFrame().addError(
                          new CssError(new InvalidParamException("at-rule",
                                                                 token, ac)));
            skipStatement();
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void operator(CssExpression expr) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
if (expr.getCount() > 0) expr.setOperator(',');
      label_71:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          break label_71;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      ;
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char combinator() throws ParseException {char connector = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case GREATER:
    case TILDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
connector = '+' ;
        break;
        }
      case GREATER:{
        jj_consume_token(GREATER);
connector = '>' ;
        break;
        }
      case TILDE:{
        jj_consume_token(TILDE);
connector = '~' ;
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_72:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[90] = jj_gen;
          break label_72;
        }
        jj_consume_token(S);
      }
      break;
      }
    case S:{
      label_73:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[91] = jj_gen;
          break label_73;
        }
      }
connector = ' ' ;
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return connector;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
{if ("" != null) return '-';}
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
{if ("" != null) return '+';}
      break;
      }
    default:
      jj_la1[93] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String property() throws ParseException {Token n;
    n = jj_consume_token(IDENT);
    label_74:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        break label_74;
      }
      jj_consume_token(S);
    }
currentProperty = convertIdent(n.image);
                         {if ("" != null) return currentProperty;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void ruleSet() throws ParseException {CssSelectors contextual;
    ArrayList<CssSelectors> context_set = new ArrayList<CssSelectors>();
    ArrayList<CssProperty> value_set = null;
    currentContext = context_set;
    try {
      contextual = selector();
if (contextual != null) {
                    context_set.add(contextual);
                }
      label_75:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[95] = jj_gen;
          break label_75;
        }
        jj_consume_token(COMMA);
        label_76:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[96] = jj_gen;
            break label_76;
          }
          jj_consume_token(S);
        }
        contextual = selector();
if (contextual != null) {
                    context_set.add(contextual);
                }
      }
      jj_consume_token(LBRACE);
validSelector = (context_set.size() > 0);
      label_77:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[97] = jj_gen;
          break label_77;
        }
        jj_consume_token(S);
      }
      value_set = declarations();
      jj_consume_token(RBRACE);
      label_78:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[98] = jj_gen;
          break label_78;
        }
        jj_consume_token(S);
      }
markRule = true;

                /*      if (value_set == null) {
			ac.getFrame().addWarning("no-declaration");
			} else {*/
                if (value_set != null) {
                    boolean first = true;
                    for (CssSelectors sel : context_set) {
                        if (first) {
                            handleRule(sel, value_set);
                            first = false;
                        } else {
                            // we need to duplicate properties in that case
                            // as property holds reference to the selectors and it interact
                            // badly with conflict detection
                            int vsize = value_set.size();
                            ArrayList<CssProperty> v = new ArrayList<CssProperty>(vsize);
                            for (CssProperty p : value_set) {
                                v.add(p.duplicate());
                            }
                            handleRule(sel, v);
                        }
                    }
                    setSelectorList(context_set);
                    endOfRule();
                }
                currentContext = null;
    } catch (ParseException e) {
if ((ac.getCssProfile() != CssProfile.MOBILE) && !context_set.isEmpty()) {
                addError(e, skipStatement());
        }
    } catch (TokenMgrError e) {
addError(new ParseException(e.getMessage()), skipStatement());
    }
  }

  final public ArrayList<CssProperty> declarations() throws ParseException {if(!validSelector) {
        validSelector = true;
        skip_to_matching_brace();
        return null;
    }

    CssProperty values;
    ArrayList<CssProperty> value_set   = new ArrayList<CssProperty>();
    boolean wrong_value = true;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      values = declaration();
if (values != null) {
                value_set.add(values);
                wrong_value = false;
            } /* else {
		 wrong_value = true;
		 } */
          currentProperty = null;
      break;
      }
    default:
      jj_la1[99] = jj_gen;
      ;
    }
    label_79:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        break label_79;
      }
      jj_consume_token(SEMICOLON);
      label_80:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[101] = jj_gen;
          break label_80;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        values = declaration();
if (values != null) {
                      value_set.add(values);
                      wrong_value = false;
                  }/* else {
		      wrong_value = true;
		      }*/
                currentProperty = null;
        break;
        }
      default:
        jj_la1[102] = jj_gen;
        ;
      }
    }
if (!wrong_value) {
                addProperty(value_set);
                {if ("" != null) return value_set;}
            } else {
                {if ("" != null) return null;}
            }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssSelectors selector() throws ParseException {char comb;
    CssSelectors current;
    try {
      current = simple_selector(null);
      label_81:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case PLUS:
        case GREATER:
        case TILDE:{
          ;
          break;
          }
        default:
          jj_la1[103] = jj_gen;
          break label_81;
        }
        comb = combinator();
if ((ac.getCssProfile() == CssProfile.MOBILE) ||
                        getAtRule().toString().equals("@media atsc-tv") ||
                        (ac.getCssVersion() == CssVersion.CSS1)) {
                        if (comb == '+') {
                            {if (true) throw new InvalidParamException("nocomb", "+", ac);}
                        }
                        if (comb == '>') {
                            {if (true) throw new InvalidParamException("nocomb", ">", ac);}
                        }
                } else if (ac.getCssProfile() == CssProfile.TV) {
                        if (comb == '+') {
                            {if (true) throw new InvalidParamException("nocomb", "+", ac);}
                    }
                }
                // if version < CSS3, ~ is undefined
                if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                    if (comb == '~') {
                            {if (true) throw new InvalidParamException("nocomb", "~", ac);}
                    }
                }
                switch(comb) {
                case '+':
                current.addAdjacentSibling(new AdjacentSiblingSelector());
                break;
                case '>':
                current.addChild(new ChildSelector());
                break;
                case '~':
                current.addGeneralSibling(new GeneralSiblingSelector());
                break;
                default:
                current.addDescendant(new DescendantSelector());
                }
                //current.setConnector(comb); 

        current = simple_selector(current);
      }
{if ("" != null) return current;}
    } catch (InvalidParamException ie) {
//	skipStatement();
        //	removeThisRule();
        ac.getFrame().addError(new CssError(ie));
        Token t = getToken(1);
        StringBuilder s = new StringBuilder();
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        {if ("" != null) return null;}
    } catch (ParseException e) {
//	validSelector = false;
        Token t = getToken(1);
        StringBuilder s = new StringBuilder("[");
        s.append(getToken(0).image);
        // eat until , { or EOF
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF)) {
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        }
        s.append(']');
        //	if (validSelector) {
        addError(e, s.toString());
            //	} else {
            //  addError(e,"");
            //	}
        validSelector = true;
        {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * I made this rule to parse a selector from a document. Combinator are avoid.
 * @exception ParseException exception during the parse
 */
  final public CssSelectors externalSelector() throws ParseException {CssSelectors current;
    current = simple_selector(null);
    label_82:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        break label_82;
      }
      label_83:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[105] = jj_gen;
          break label_83;
        }
      }
      current = simple_selector(current);
    }
{if ("" != null) return current;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssSelectors simple_selector(CssSelectors next) throws ParseException {CssSelectors selector = new CssSelectors(ac, next);
    selector.setAtRule(getAtRule());
    //selector.setUserMedium(getUserMedium());

    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:
    case ANY:
    case 104:{
      element_name(selector);
      label_84:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case CLASS:
        case FUNCTIONNOT:{
          ;
          break;
          }
        default:
          jj_la1[106] = jj_gen;
          break label_84;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:{
          hash(selector);
          break;
          }
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case CLASS:{
          _class(selector);
          break;
          }
        case LBRACKET:{
          attrib(selector);
          break;
          }
        case COLON:
        case PSEUDOELEMENT_SYM:{
          pseudo(selector);
          break;
          }
        case FUNCTIONNOT:{
          negation(selector);
          break;
          }
        default:
          jj_la1[107] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
{if ("" != null) return selector;}
      break;
      }
    case HASHIDENT:
    case HASH:
    case LBRACKET:
    case COLON:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:
    case PSEUDOELEMENT_SYM:
    case CLASS:
    case FUNCTIONNOT:{
      label_85:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:{
          hash(selector);
          break;
          }
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case CLASS:{
          _class(selector);
          break;
          }
        case LBRACKET:{
          attrib(selector);
          break;
          }
        case COLON:
        case PSEUDOELEMENT_SYM:{
          pseudo(selector);
          break;
          }
        case FUNCTIONNOT:{
          negation(selector);
          break;
          }
        default:
          jj_la1[108] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASHIDENT:
        case HASH:
        case LBRACKET:
        case COLON:
        case RELFONTLENGTH:
        case RELVIEWLENGTH:
        case ABSOLUTLENGTH:
        case ANGLE:
        case TIME:
        case FREQ:
        case RESOLUTION:
        case DIMEN:
        case PSEUDOELEMENT_SYM:
        case CLASS:
        case FUNCTIONNOT:{
          ;
          break;
          }
        default:
          jj_la1[109] = jj_gen;
          break label_85;
        }
      }
{if ("" != null) return selector;}
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void _class(CssSelectors s) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLASS:{
      /*  "." n=<IDENT> { */
          n = jj_consume_token(CLASS);
try {
            s.addClass(new ClassSelector(convertClassIdent(n.image.substring(1))));
            //        s.addAttribute("class", convertIdent(n.image.substring(1)),
            //           CssSelectors.ATTRIBUTE_CLASS_SEL);
        } catch (InvalidParamException e) {
            //	    removeThisRule();
             ac.getFrame().addError(new CssError(e));
            {if (true) throw new ParseException(e.getMessage());}
        }
      break;
      }
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:{
      n = deprecated_class();
if (n.image.charAt(0) == '.') {
            n.image = n.image.substring(1);

            // the class with the first digit escaped
            String cl = "."+hexEscapeFirst(n.image);

        CssVersion version = ac.getCssVersion();
//	    String profile = ac.getProfile();
//	    if(profile == null || profile.equals("") || profile.equals("none")) {
//		profile = ac.getCssVersionString();
//	    }

            if(version != CssVersion.CSS1) {
                StringBuilder sb = new StringBuilder();
                ArrayList<String> param_err = new ArrayList<String>(2);
                param_err.add(n.image);
                param_err.add(cl);
                sb.append(ac.getMsg().getString("parser.old_class", param_err));
                {if (true) throw new ParseException(sb.toString());}
                //		s.addClass(new ClassSelector(n.image));                            
                // removeThisRule();              
            }
            else {
                CssLength length = new CssLength();
                boolean isLength = false;
                try {
                    length.set(n.image, ac);
                    isLength = true;
                }
                catch(Exception e) {
                    isLength = false;
                }
                if(isLength) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ac.getMsg().getString("parser.class_dim"));
                    sb.append(n.image);
                    {if (true) throw new ParseException(sb.toString());}
                    //		    s.addClass(new ClassSelector(n.image));                            
                    // removeThisRule();
                }
                else {
                    try {
                        // for css > 1, we add the rule to have a context, 
                        // and we then remove it
                        s.addClass(new ClassSelector(n.image));
                        ac.getFrame().addWarning("old_class");
                    } catch (InvalidParamException e) {
                        {if (true) throw new ParseException(e.getMessage());}
                        //ac.getFrame().addError(new CssError(e));
                        //removeThisRule();
                    }
                }
            }
        } else {
            {if (true) throw new ParseException("Unrecognized ");}
        }
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token deprecated_class() throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RELFONTLENGTH:{
      n = jj_consume_token(RELFONTLENGTH);
      break;
      }
    case RELVIEWLENGTH:{
      n = jj_consume_token(RELVIEWLENGTH);
      break;
      }
    case ABSOLUTLENGTH:{
      n = jj_consume_token(ABSOLUTLENGTH);
      break;
      }
    case ANGLE:{
      n = jj_consume_token(ANGLE);
      break;
      }
    case TIME:{
      n = jj_consume_token(TIME);
      break;
      }
    case FREQ:{
      n = jj_consume_token(FREQ);
      break;
      }
    case RESOLUTION:{
      n = jj_consume_token(RESOLUTION);
      break;
      }
    case DIMEN:{
      n = jj_consume_token(DIMEN);
      break;
      }
    default:
      jj_la1[112] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void element_name(CssSelectors s) throws ParseException {Token n=null;
    Token p=null;
    String prefix = null;
    if (jj_2_1(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case ANY:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:{
          n = jj_consume_token(IDENT);
          break;
          }
        case ANY:{
          n = jj_consume_token(ANY);
          break;
          }
        default:
          jj_la1[113] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        ;
      }
      p = jj_consume_token(104);
    } else {
      ;
    }
// FIXME namespace, check versions of CSS in a better way.
        if (p != null) {
            // FIXME should be > CSS3
            if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
                StringBuilder sb = new StringBuilder("namespace \"");
                if (n != null) sb.append(n.toString());
                sb.append("\"");
                ac.getFrame().addError(new CssError(new
                                          InvalidParamException("notversion",
                                                                "namespace",
                                                            ac.getCssVersionString(),
                                                                ac)));
                removeThisRule();
            } else if (n!=null) {
                prefix = convertIdent(n.image);
                if (!ac.isNamespaceDefined(getURL(), prefix)) {
                    // ns is not defined
                    addError(new ParseException("Undefined namespace"),
                             ": The namespace \""+prefix
                             +"\" is not defined. "
                             + prefix );
                    removeThisRule();
                }
            } else {
                prefix = "";
            }
        }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      n = jj_consume_token(IDENT);
//              s.setElement(convertIdent(n.image), ac);
        s.addType(new TypeSelector(prefix, convertIdent(n.image)));
      break;
      }
    case ANY:{
      jj_consume_token(ANY);
if (ac.getCssVersion() != CssVersion.CSS1) {
            //          s.setElement(null);
            s.addUniversal(new UniversalSelector(prefix));
        } else {
            ac.getFrame().addError(new CssError(new InvalidParamException("notversion",
                                                                          "*", ac.getCssVersionString(), ac)));
        }
      break;
      }
    default:
      jj_la1[115] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void attrib(CssSelectors s) throws ParseException {Token att = null;
    Token val = null;
    int selectorType = CssSelectors.ATTRIBUTE_ANY;
    jj_consume_token(LBRACKET);
    label_86:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[116] = jj_gen;
        break label_86;
      }
      jj_consume_token(S);
    }
    att = jj_consume_token(IDENT);
    label_87:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[117] = jj_gen;
        break label_87;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INCLUDES:
    case DASHMATCH:
    case PREFIXMATCH:
    case SUFFIXMATCH:
    case SUBSTRINGMATCH:
    case EQ:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
selectorType = CssSelectors.ATTRIBUTE_EXACT;
        break;
        }
      case INCLUDES:{
        jj_consume_token(INCLUDES);
selectorType = CssSelectors.ATTRIBUTE_ONE_OF;
        break;
        }
      case DASHMATCH:{
        jj_consume_token(DASHMATCH);
selectorType = CssSelectors.ATTRIBUTE_BEGIN;
        break;
        }
      case PREFIXMATCH:{
        jj_consume_token(PREFIXMATCH);
selectorType = CssSelectors.ATTRIBUTE_START;
        break;
        }
      case SUFFIXMATCH:{
        jj_consume_token(SUFFIXMATCH);
selectorType = CssSelectors.ATTRIBUTE_SUFFIX;
        break;
        }
      case SUBSTRINGMATCH:{
        jj_consume_token(SUBSTRINGMATCH);
selectorType = CssSelectors.ATTRIBUTE_SUBSTR;
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_88:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[119] = jj_gen;
          break label_88;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        val = jj_consume_token(IDENT);
val.image = convertIdent(val.image);
        break;
        }
      case STRING:{
        val = jj_consume_token(STRING);
val.image = convertStringIndex(val.image, 1, val.image.length() -1, false);
        break;
        }
      default:
        jj_la1[120] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_89:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[121] = jj_gen;
          break label_89;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[122] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
if (ac.getCssVersion() == CssVersion.CSS1) {
              StringBuilder reason;
              CssParseException cp;
              ParseException p;
              reason = new StringBuilder(" [");
              if (att != null) {
                  reason.append(convertIdent(att.image));
              }
              if (val != null ) {
                  reason.append('=').append(val.image);
              }
              reason.append(']');
              p = new ParseException(ac.getMsg().getString("parser.attrcss1")+
                                     reason.toString());
              cp = new CssParseException(p);
              ac.getFrame().addError(new CssError(cp));
              removeThisRule();
          }
          if (selectorType == CssSelectors.ATTRIBUTE_ANY) {
              try {
                  s.addAttribute(new AttributeAny(att.image.toLowerCase()));
//                s.addAttribute(att.image.toLowerCase(), null, selectorType);
              } catch (InvalidParamException e) {
                  removeThisRule();
                  ac.getFrame().addError(new CssError(e));
              }
          } else {
              AttributeSelector attribute;
              switch(selectorType) {
              case CssSelectors.ATTRIBUTE_BEGIN:
                  attribute = new AttributeBegin(att.image.toLowerCase(),
                          val.image);
                  break;
              case CssSelectors.ATTRIBUTE_EXACT:
                  attribute = new AttributeExact(att.image.toLowerCase(),
                          val.image);
                  break;
              case CssSelectors.ATTRIBUTE_ONE_OF:
                  attribute = new AttributeOneOf(att.image.toLowerCase(),
                          val.image);
                  break;
              case CssSelectors.ATTRIBUTE_START:
                  attribute = new AttributeStart(att.image.toLowerCase(),
                          val.image);
                  break;
              case CssSelectors.ATTRIBUTE_SUBSTR:
                  attribute = new AttributeSubstr(att.image.toLowerCase(),
                          val.image);
                  break;
              case CssSelectors.ATTRIBUTE_SUFFIX:
                  attribute = new AttributeSuffix(att.image.toLowerCase(),
                          val.image);
                  break;
              default:
                  attribute = new AttributeExact(att.image.toLowerCase(),
                          val.image);
                  break;
              }
              try {
                  s.addAttribute(attribute);
//	      	  s.addAttribute(att.image.toLowerCase(), val.image, 
//			     selectorType);
              } catch (InvalidParamException e) {
                  removeThisRule();
                  ac.getFrame().addError(new CssError(e));
              }
          }
  }

  final public void negation(CssSelectors s) throws ParseException {Token n;
    CssSelectors ns = new CssSelectors(ac, null);
    jj_consume_token(FUNCTIONNOT);
    label_90:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        break label_90;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:
    case ANY:
    case 104:{
      element_name(ns);
      break;
      }
    case HASHIDENT:
    case HASH:{
      hash(ns);
      break;
      }
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case ANGLE:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:
    case CLASS:{
      _class(ns);
      break;
      }
    case LBRACKET:{
      attrib(ns);
      break;
      }
    case COLON:
    case PSEUDOELEMENT_SYM:{
      pseudo(ns);
      break;
      }
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_91:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        break label_91;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LPARAN);
s.setPseudoFun("not", ns.toString());
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void pseudo(CssSelectors s) throws ParseException {Token n;
Token language = null;
CssExpression param = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PSEUDOELEMENT_SYM:{
      jj_consume_token(PSEUDOELEMENT_SYM);
      n = jj_consume_token(IDENT);
try {
            // should be >CSS3
                if (ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0) {
                    s.addPseudoElement(convertIdent(n.image).toLowerCase());
                } else {
                    {if (true) throw new InvalidParamException("pseudo-element",
                                                    "::" + convertIdent(n.image).toLowerCase() ,
                                                    ac.getCssVersionString() ,ac);}
                }
            } catch(InvalidParamException e) {
                //	removeThisRule();
                //		ac.getFrame().addError(new CssError(e));
                validSelector = false;
                {if (true) throw new ParseException(e.getMessage());}
            }
      break;
      }
    case COLON:{
      jj_consume_token(COLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        n = jj_consume_token(IDENT);
try {
                    s.addPseudoClass(convertIdent(n.image).toLowerCase());
                } catch(InvalidParamException e) {
                    removeThisRule();
                    ac.getFrame().addError(new CssError(e));
                }
        break;
        }
      case FUNCTIONLANG:
      case FUNCTION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FUNCTIONLANG:{
          n = jj_consume_token(FUNCTIONLANG);
          label_92:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[126] = jj_gen;
              break label_92;
            }
            jj_consume_token(S);
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NUMBER:{
            language = jj_consume_token(NUMBER);
            break;
            }
          case IDENT:{
            language = jj_consume_token(IDENT);
            break;
            }
          case STRING:{
            language = jj_consume_token(STRING);
            break;
            }
          default:
            jj_la1[127] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_93:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[128] = jj_gen;
              break label_93;
            }
            jj_consume_token(S);
          }
try {
                    s.setPseudoFun(convertStringIndex(n.image, 0,
                                                      n.image.length() -1, false).toLowerCase(),
                                   convertIdent(language.image));
                } catch(InvalidParamException e) {
                        removeThisRule();
                        ac.getFrame().addError(new CssError(e));
                }
          break;
          }
        case FUNCTION:{
          n = jj_consume_token(FUNCTION);
          label_94:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[129] = jj_gen;
              break label_94;
            }
            jj_consume_token(S);
          }
          param = expression();
try {
                    s.setPseudoFun(convertStringIndex(n.image, 0,
                                                      n.image.length() -1,
                                                      false).toLowerCase(),
                                   param.toString());
                } catch(InvalidParamException e) {
                    removeThisRule();
                    ac.getFrame().addError(new CssError(e));
                }
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPARAN);
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[132] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void hash(CssSelectors s) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HASHIDENT:{
      n = jj_consume_token(HASHIDENT);
n.image = n.image.substring(1);
      if(Character.isDigit(n.image.charAt(0))) {

      CssVersion version = ac.getCssVersion();

      if (version != CssVersion.CSS1) {
              // the id with the first digit escaped
              String cl = "\\" + Integer.toString(n.image.charAt(0), 16);
              cl += n.image.substring(1);

              addError(new ParseException(ac.getMsg().getString(
                "parser.old_id")),
                "To make \"." + n.image + "\" a valid id, CSS2" +
                " requires the first digit to be escaped " +
                "(\"#" + cl + "\")");
              // for css > 1, we add the rule to have a context, 
              // and we then remove it
              s.addId(new IdSelector(n.image));
              removeThisRule();
          }
          else {
              CssLength length = new CssLength();
              boolean isLength = false;
              try {
                  length.set(n.image, ac);
                  isLength = true;
              }
              catch(Exception e) {
                  isLength = false;
              }
              if(isLength) {
                  addError(new ParseException(ac.getMsg().getString(
                  "parser.id_dim")), n.image);
                  // we add the rule to have a context, and then we remove it
                  s.addId(new IdSelector(n.image));
                  removeThisRule();
              }
              else {
                  try {
                      s.addId(new IdSelector(n.image));
                      ac.getFrame().addWarning("old_id");
                  } catch (InvalidParamException e) {
                      ac.getFrame().addError(new CssError(e));
                      removeThisRule();
                  }
              }
          }
      }
      else {
          try {
              s.addId(new IdSelector(n.image));
          } catch (InvalidParamException e) {
              ac.getFrame().addError(new CssError(e));
              removeThisRule();
          }
      }
      break;
      }
    case HASH:{
      n = jj_consume_token(HASH);
{if (true) throw new ParseException(ac.getMsg().getString("parser.invalid_id_selector"));}
      break;
      }
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssProperty mediadeclaration() throws ParseException {String string_property;
  CssExpression values = null;
  boolean important = false;
  setMediaDeclaration(true);
    try {
      string_property = property();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        label_95:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[134] = jj_gen;
            break label_95;
          }
          jj_consume_token(S);
        }
        values = expr();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORTANT_SYM:{
          important = prio();
          break;
          }
        default:
          jj_la1[135] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[136] = jj_gen;
        ;
      }
try {

            setImportant(important);

            if (incompatible_error) {
                {if (true) throw new InvalidParamException("notforcss1", "inherit", ac);}
            }

            CssProperty p = handleDeclaration(string_property.toLowerCase(),
                                                  values, important);
            {if ("" != null) return p;}

        } catch (InvalidParamException e) {
                incompatible_error = false;
                if (null != values) {
                        values.starts();
                }
                addError(e, (CssExpression) values);
        }
        {if ("" != null) return null;}
    } catch (NumberFormatException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (ParseException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } finally {
setMediaDeclaration(false);
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssProperty declaration() throws ParseException {String string_property;
  CssExpression values;
  boolean important = false;
    try {
      string_property = property();
      jj_consume_token(COLON);
      label_96:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[137] = jj_gen;
          break label_96;
        }
        jj_consume_token(S);
      }
      values = expr();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORTANT_SYM:{
        important = prio();
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        ;
      }
try {

            setImportant(important);

            if (incompatible_error) {
                {if (true) throw new InvalidParamException("notforcss1", "inherit", ac);}
            }

            if (values.getCount() != 0) {
                CssProperty p = handleDeclaration(string_property.toLowerCase(),
                                                  values, important);
                // Did the property recognize all values in the expression ?

                if (!values.end() && ac.getMedium() == null) {
                        addError(new InvalidParamException("unrecognize", "", ac),
                             values);
                } else {
                    // ok, return the new property
                    {if ("" != null) return p;}
                }
            }
        } catch (InvalidParamException e) {
            incompatible_error = false;
            if (e instanceof WarningParamException) {
                WarningParamException warningException =
                    (WarningParamException) e;
                ac.getFrame().addWarning(warningException.getMessage(),
                                         warningException.getMessageArgs());
            } else {
                values.starts();
                addError(e, (CssExpression) values);
            }
        }
        {if ("" != null) return null;}
    } catch (NumberFormatException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (ParseException e) {
skipAfterExpression(e);
     {if ("" != null) return null;}
    } catch (NullPointerException e) {
// NullPointerException happen if in handling a property
        // something bad happen (like setting values on sub properties
        // that had not been initialized (for an unknown reason yet).
     skipAfterExpression(e);
     {if ("" != null) return null;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_97:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        break label_97;
      }
      jj_consume_token(S);
    }
{if ("" != null) return true;}
    throw new Error("Missing return statement in function");
  }

  final public CssExpression expression() throws ParseException {CssExpression exp = new CssExpression();
    char operator = ' ';
    Token n = null;
    label_98:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
operator = '+' ;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
operator = '-';
        break;
        }
      case NUMBER:{
        n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n, PERCENTAGE);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
setValue(new CssIdent(), exp, operator, n, IDENT);
        break;
        }
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case IDENT:{
        n = jj_consume_token(IDENT);
setValue(new CssIdent(), exp, operator, n, IDENT);
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_99:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[141] = jj_gen;
          break label_99;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case STRING:
      case IDENT:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:{
        ;
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        break label_98;
      }
    }
{if ("" != null) return exp;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssExpression expr() throws ParseException {CssExpression values = new CssExpression();
    term(values);
    label_100:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case COMMA:
      case STRING:
      case IDENT:
      case HASHIDENT:
      case HASH:
      case DIV:
      case LBRACKET:
      case RBRACKET:
      case URL:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case FLEX:
      case ANGLE:
      case SPL:
      case ST:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:
      case UNICODERANGE:
      case FUNCTIONCALC:
      case FUNCTIONATTR:
      case FUNCTION:{
        ;
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        break label_100;
      }
      operator(values);
      term(values);
    }
{if ("" != null) return values;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssExpression mediaexpr() throws ParseException {CssExpression values = new CssExpression();
    mediaterm(values);
    label_101:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case COMMA:
      case STRING:
      case IDENT:
      case HASHIDENT:
      case HASH:
      case URL:
      case RELFONTLENGTH:
      case RELVIEWLENGTH:
      case ABSOLUTLENGTH:
      case FLEX:
      case ANGLE:
      case SPL:
      case ST:
      case TIME:
      case FREQ:
      case RESOLUTION:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:
      case UNICODERANGE:
      case FUNCTION:{
        ;
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        break label_101;
      }
      operator(values);
      mediaterm(values);
    }
{if ("" != null) return values;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void term(CssExpression exp) throws ParseException {Token n;
  char operator = ' ';
  CssValue func;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case SPL:
    case ST:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:
    case PERCENTAGE:
    case NUMBER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n, PERCENTAGE);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
setValue(new CssLength(), exp, operator, n, RELFONTLENGTH);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
setValue(new CssLength(), exp, operator, n, RELVIEWLENGTH);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
setValue(new CssLength(), exp, operator, n, ABSOLUTLENGTH);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
setValue(new CssFlexibleLength(), exp, operator, n, FLEX);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
setValue(new CssAngle(), exp, operator, n, ANGLE);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
setValue(new CssTime(), exp, operator, n, TIME);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
setValue(new CssFrequency(), exp, operator, n, FREQ);
        break;
        }
      case RESOLUTION:{
        n = jj_consume_token(RESOLUTION);
setValue(new CssResolution(), exp, operator, n, RESOLUTION);
        break;
        }
      case ST:{
        n = jj_consume_token(ST);
setValue(new CssSemitone(), exp, operator, n, ST);
        break;
        }
      case SPL:{
        n = jj_consume_token(SPL);
setValue(new CssVolume(), exp, operator, n, SPL);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), n.image);
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case STRING:
    case IDENT:
    case HASHIDENT:
    case HASH:
    case DIV:
    case LBRACKET:
    case RBRACKET:
    case URL:
    case UNICODERANGE:
    case FUNCTIONCALC:
    case FUNCTIONATTR:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FUNCTIONCALC:{
        func = mathcalc();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTIONATTR:{
        func = attr();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case FUNCTION:{
        func = function();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case DIV:{
        n = jj_consume_token(DIV);
setValue(new CssSwitch(), exp, operator, n, DIV);
        break;
        }
      case LBRACKET:
      case RBRACKET:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case RBRACKET:{
          n = jj_consume_token(RBRACKET);
          break;
          }
        case LBRACKET:{
          n = jj_consume_token(LBRACKET);
          break;
          }
        default:
          jj_la1[147] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
setValue(new CssBracket(), exp, operator, n, RBRACKET);
        break;
        }
      case IDENT:{
        n = jj_consume_token(IDENT);
/*
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 */
            Token t = getToken(1);
            Token semicolon = new Token();
            semicolon.kind = SEMICOLON;
            semicolon.image = ";";
            if (t.kind == COLON) {
                /* @@SEEME. (generate a warning?) */
                /* @@SEEME if expression is a single ident, 
		   generate an error ? */
                addError(new ParseException(ac.getMsg().getString("parser.semi-colon")),
                         (CssExpression) null);
                rejectToken(semicolon);
            } else {
                setValue(new CssIdent(), exp, operator, n, IDENT);
            }
        break;
        }
      case HASHIDENT:
      case HASH:{
        hashident(exp);
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
CssURL _u = new CssURL();
            _u.set(n.image, ac, url);
            exp.addValue(_u);
        break;
        }
      case UNICODERANGE:{
        n = jj_consume_token(UNICODERANGE);
setValue(new CssUnicodeRange(), exp, operator, n, UNICODERANGE);
        break;
        }
      default:
        jj_la1[148] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_102:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        break label_102;
      }
      jj_consume_token(S);
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void mediaterm(CssExpression exp) throws ParseException {Token n;
  char operator = ' ';
  CssValue func;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case SPL:
    case ST:
    case TIME:
    case FREQ:
    case RESOLUTION:
    case DIMEN:
    case PERCENTAGE:
    case NUMBER:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        if (jj_2_2(2147483647)) {
          ratio(exp, operator);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NUMBER:{
            n = jj_consume_token(NUMBER);
setValue(new CssNumber(), exp, operator, n, NUMBER);
            break;
            }
          default:
            jj_la1[152] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
setValue(new CssPercentage(), exp, operator, n,
                                PERCENTAGE);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
setValue(new CssLength(), exp, operator, n, RELFONTLENGTH);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
setValue(new CssLength(), exp, operator, n, RELVIEWLENGTH);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
setValue(new CssLength(), exp, operator, n, ABSOLUTLENGTH);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
setValue(new CssFlexibleLength(), exp, operator, n, FLEX);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
setValue(new CssAngle(), exp, operator, n, ANGLE);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
setValue(new CssTime(), exp, operator, n, TIME);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
setValue(new CssFrequency(), exp, operator, n, FREQ);
        break;
        }
      case RESOLUTION:{
        n = jj_consume_token(RESOLUTION);
setValue(new CssResolution(), exp, operator, n, RESOLUTION);
        break;
        }
      case ST:{
        n = jj_consume_token(ST);
setValue(new CssSemitone(), exp, operator, n, ST);
        break;
        }
      case SPL:{
        n = jj_consume_token(SPL);
setValue(new CssVolume(), exp, operator, n, SPL);
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
addError(new ParseException(ac.getMsg().getString("parser.unknown-dimension")), n.image);
        break;
        }
      case FUNCTION:{
        func = function();
setValue(func, exp, operator, null, FUNCTION);
        break;
        }
      default:
        jj_la1[153] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_103:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[154] = jj_gen;
          break label_103;
        }
        jj_consume_token(S);
      }
      break;
      }
    case STRING:
    case IDENT:
    case HASHIDENT:
    case HASH:
    case URL:
    case UNICODERANGE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        n = jj_consume_token(STRING);
setValue(new CssString(), exp, operator, n, STRING);
        break;
        }
      case IDENT:{
        n = jj_consume_token(IDENT);
/*
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 */
        Token t = getToken(1);
        Token semicolon = new Token();
        semicolon.kind = SEMICOLON;
        semicolon.image = ";";
        if (t.kind == COLON) {
            /* @@SEEME. (generate a warning?) */
            /* @@SEEME if expression is a single ident,
	       generate an error ? */
            addError(new ParseException(ac.getMsg().getString("parser.semi-colon")),
                     (CssExpression) null);
            rejectToken(semicolon);
        } else {
            setValue(new CssIdent(), exp, operator, n, IDENT);
        }
        break;
        }
      case HASHIDENT:
      case HASH:{
        hashident(exp);
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
CssURL _u = new CssURL();
        _u.set(n.image, ac, url);
        exp.addValue(_u);
        break;
        }
      case UNICODERANGE:{
        n = jj_consume_token(UNICODERANGE);
setValue(new CssUnicodeRange(), exp, operator, n,
                                UNICODERANGE);
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_104:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[156] = jj_gen;
          break label_104;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[157] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public CssCheckableValue mathcalc() throws ParseException {CssCheckableValue v;
CssCalc c;
    jj_consume_token(FUNCTIONCALC);
    label_105:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        break label_105;
      }
      jj_consume_token(S);
    }
    v = mathsum();
    label_106:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        break label_106;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LPARAN);
if (v.getRawType() != CssTypes.CSS_CALC) {
       c = new CssCalc(v);
    } else {
       c = (CssCalc) v;
    }
    c.validate();
    {if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathsum() throws ParseException {Token n,o;
  CssCheckableValue v1 = null;
  CssCheckableValue v2 = null;
  CssCalc c, nc;
  boolean concat = false;
  int nb_pre_sp;
    v1 = mathproduct();
c = new CssCalc(ac, v1);
                          nb_pre_sp = 0;
    label_107:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_107;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        o = jj_consume_token(PLUS);
        break;
        }
      case S:
      case MINUS:{
        label_108:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[160] = jj_gen;
            break label_108;
          }
          jj_consume_token(S);
nb_pre_sp++;
        }
        o = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (o.image.length() < 2 && nb_pre_sp == 0) {
                {if (true) throw new ParseException(ac.getMsg().getString("parser.calcwhitespace"));}
            }
      label_109:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[162] = jj_gen;
          break label_109;
        }
      }
      v2 = mathproduct();
nb_pre_sp = 0;
            if (concat) {
                nc = new CssCalc(ac, c);
                nc.addRightSide(o.image.trim(), v2);
                c = nc;
            } else {
                c.addRightSide(o.image.trim(), v2);
                concat = true;
            }
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathproduct() throws ParseException {Token n,o;
  CssCheckableValue v1 = null;
  CssCheckableValue v2 = null;
  CssCalc c, nc;
  char operator = ' ';
  boolean concat = false;
    v1 = mathunit();
c = new CssCalc(ac, v1);
    label_110:
    while (true) {
      if (jj_2_4(2)) {
        ;
      } else {
        break label_110;
      }
      label_111:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[163] = jj_gen;
          break label_111;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ANY:{
        o = jj_consume_token(ANY);
        label_112:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[164] = jj_gen;
            break label_112;
          }
          jj_consume_token(S);
        }
        v2 = mathunit();
        break;
        }
      case DIV:{
        o = jj_consume_token(DIV);
        label_113:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[165] = jj_gen;
            break label_113;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:
        case MINUS:{
          operator = unaryOperator();
          break;
          }
        default:
          jj_la1[166] = jj_gen;
          ;
        }
        n = jj_consume_token(NUMBER);
v2 = new CssNumber(); v2.set(addOperator(operator, n.image), ac);
        break;
        }
      default:
        jj_la1[167] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (concat) {
                              nc = new CssCalc(ac, c);
                              nc.addRightSide(o.image, v2);
                              c = nc;
                          } else {
                              c.addRightSide(o.image, v2);
                              concat = true;
                          }
    }
{if ("" != null) return c;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue mathunit() throws ParseException {Token n;
CssCheckableValue v = null;
char operator = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case RELFONTLENGTH:
    case RELVIEWLENGTH:
    case ABSOLUTLENGTH:
    case FLEX:
    case ANGLE:
    case TIME:
    case FREQ:
    case PERCENTAGE:
    case NUMBER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        operator = unaryOperator();
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        n = jj_consume_token(NUMBER);
v = new CssNumber(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
v = new CssPercentage(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case RELFONTLENGTH:{
        n = jj_consume_token(RELFONTLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case RELVIEWLENGTH:{
        n = jj_consume_token(RELVIEWLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case ABSOLUTLENGTH:{
        n = jj_consume_token(ABSOLUTLENGTH);
v = new CssLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case FLEX:{
        n = jj_consume_token(FLEX);
v = new CssFlexibleLength(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case ANGLE:{
        n = jj_consume_token(ANGLE);
v = new CssAngle(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case TIME:{
        n = jj_consume_token(TIME);
v = new CssTime(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      case FREQ:{
        n = jj_consume_token(FREQ);
v= new CssFrequency(); v.set(addOperator(operator, n.image), ac);
        break;
        }
      default:
        jj_la1[169] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case RPARAN:{
      jj_consume_token(RPARAN);
      label_114:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[170] = jj_gen;
          break label_114;
        }
        jj_consume_token(S);
      }
      v = mathsum();
      label_115:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[171] = jj_gen;
          break label_115;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LPARAN);
((CssCalc) v).setParenthesis();
      break;
      }
    case FUNCTIONCALC:{
      v = mathcalc();
      break;
      }
    case FUNCTIONATTR:{
      v = attr();
      break;
      }
    default:
      jj_la1[172] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return v;}
    throw new Error("Missing return statement in function");
  }

  final public CssCheckableValue attr() throws ParseException {CssAttr v = null;
Token n = null;
CssExpression exp = null;
    jj_consume_token(FUNCTIONATTR);
    label_116:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        break label_116;
      }
      jj_consume_token(S);
    }
    n = jj_consume_token(IDENT);
    label_117:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[174] = jj_gen;
        break label_117;
      }
      jj_consume_token(S);
    }
exp = new CssExpression();
            setValue(new CssIdent(), exp, ' ', n, IDENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:
    case 105:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        n = jj_consume_token(IDENT);
        break;
        }
      case 105:{
        n = jj_consume_token(105);
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
setValue(new CssIdent(), exp, ' ', n, IDENT);
      label_118:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          break label_118;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
exp.setOperator(',');
      label_119:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[178] = jj_gen;
          break label_119;
        }
        jj_consume_token(S);
      }
      term(exp);
      break;
      }
    default:
      jj_la1[179] = jj_gen;
      ;
    }
    jj_consume_token(LPARAN);
v = new CssAttr();
       v.setValue(exp, ac);
       {if ("" != null) return v;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public CssValue function() throws ParseException {Token n,p = null,q = null;
 CssExpression exp;
 CssColor color = new CssColor();
    n = jj_consume_token(FUNCTION);
    label_120:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[180] = jj_gen;
        break label_120;
      }
      jj_consume_token(S);
    }
    if (jj_2_5(2)) {
      exp = expr();
      jj_consume_token(LPARAN);
String funcname = n.image.toLowerCase();
        if (funcname.equals("rgb(")) {
            color.setRGBColor(exp, ac);
            {if ("" != null) return color;}
        } else if (funcname.equals("rgba(")) {
            color.setRGBAColor(exp, ac);
            {if ("" != null) return color;}
        } else if (funcname.equals("hsl(")) {
            color.setHSLColor(exp, ac);
            {if ("" != null) return color;}
        } else if (funcname.equals("hsla(")) {
            color.setHSLAColor(exp, ac);
            {if ("" != null) return color;}
        } else if (funcname.equals("image(")) {
            CssImage img = new CssImage();
            img.setImageList(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("linear-gradient(")) {
            CssImage img = new CssImage();
            img.setLinearGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("repeating-linear-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingLinearGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("radial-gradient(")) {
            CssImage img = new CssImage();
            img.setRadialGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("repeating-radial-gradient(")) {
            CssImage img = new CssImage();
            img.setRepeatingRadialGradient(exp, ac);
            {if ("" != null) return img;}
        } else if (funcname.equals("atsc-rgba(")) {
            if (getAtRule().toString().equals("@media atsc-tv")) {
                color.setATSCRGBAColor(exp, ac);
                {if ("" != null) return color;}
            } else {
                addError(new InvalidParamException("onlyATSC", "", ac),
                                                 getAtRule().toString());
                {if ("" != null) return null;}
            }
        } else {
            CssFunction f = new CssFunction();
            f.set(n.image.substring(0, n.image.length() - 1), exp);
            if (funcname.charAt(0) == '-') {
                exp.markVendorExtension();
            }
            {if ("" != null) return f;}
        }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        p = jj_consume_token(IDENT);
        jj_consume_token(EQ);
        q = jj_consume_token(NUMBER);
        jj_consume_token(LPARAN);
        break;
        }
      default:
        jj_la1[181] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
// this one is for vendor extension like alpha(opacity=50);
        exp = new CssExpression();
        setValue(new CssIdent(), exp, ' ', p, IDENT);
        exp.setOperator(CssOperator.EQUAL);
        setValue(new CssNumber(), exp, ' ', q, NUMBER);
        exp.markVendorExtension();

        CssFunction f = new CssFunction();
        f.set(n.image.substring(0, n.image.length() - 1), exp);
        {if ("" != null) return f;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void hashident(CssExpression exp) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HASHIDENT:{
      n = jj_consume_token(HASHIDENT);
      break;
      }
    case HASH:{
      n = jj_consume_token(HASH);
      break;
      }
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
n.image = Util.strip(n.image);
     setValue(new CssHashIdent(), exp, ' ', n, HASH);
  }

  String skipStatement() throws ParseException {StringBuilder s = new StringBuilder();
    Token tok = getToken(0);
    boolean first = true;

    if (tok.image != null) {
        s.append(tok.image);
    }
    /* FIXME here, two option, we skip during an error, or outside
       an error, currently both can fail with a TokenMgrError, should
       we catch all, or only when filling message for errors? 
       
       -> taking the "always skip" approach.
    */
    while (true) {
        try {
            tok = getToken(1);
            if (tok.kind == EOF) {
                if (first) {
                    return null;
                } else {
                    break;
                }
            }
            s.append(tok.image);
            if (tok.kind == LBRACE) {
                getNextToken();
                s.append(skip_to_matching_brace());
                getNextToken();
                tok = getToken(1);
                break;
            } else if ((tok.kind == RBRACE) || (tok.kind == SEMICOLON)) {
                getNextToken();
                tok = getToken(1);
                break;
            }
            getNextToken();
        } catch (TokenMgrError tokenerror) {
            // read one char at a time, and loop
            try {
                s.append(jj_input_stream.readChar());
                continue;
            } catch (java.io.IOException ioex) {
                return s.toString().trim();
            }
        }
        first = false;
    }

    // skip white space
    while (tok.kind == S) {
        getNextToken();
        tok = getToken(1);
    }
    String statement = s.toString().trim();
    return statement;
  }

  String skip_to_matching_brace() throws ParseException {StringBuilder s = new StringBuilder();
    Token tok;
    int nesting = 1;
    /* FIXME
       same as above */
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            break;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            nesting++;
        } else if (tok.kind == RBRACE) {
            nesting--;
            if (nesting == 0) {
                break;
            }
        }
        getNextToken();
    }
    return s.toString();
  }

  void rejectToken(Token t) throws ParseException {Token fakeToken = new Token();
    t.next = token;
    fakeToken.next = t;
    token = fakeToken;
  }

  void skipAfterExpression(Exception e) throws ParseException {StringBuilder s = new StringBuilder();
    s.append(getToken(0).image);
    while (true) {
        try {
            Token t = getToken(1);
            if (t.kind == LBRACE) {
                s.append(t.image);
                getNextToken();
                s.append(skip_to_matching_brace());
                getNextToken();
                t = getToken(1);
                continue;
            }
            if ((t.kind == SEMICOLON) || (t.kind == RBRACE)
                                      || (t.kind == EOF)) {
                break;
            }
            s.append(t.image);
            getNextToken();
            t = getToken(1);
        } catch (TokenMgrError tmerr) {
            try {
                s.append(jj_input_stream.readChar());
                continue;
            } catch (java.io.IOException ioex) {
                ioex.printStackTrace();
                break;
            }
        }
    }
    String statement = s.toString().trim();
    addError(e, s.toString());
  }

  String convertStringIndex(String s, int start, int len, boolean escapeFirst) throws ParseException {int index = start;
    int t;
    int maxCount = 0;
    if ((start == 0) && (len == s.length()) && (s.indexOf('\\') == -1)) {
        return s;
    }
    StringBuilder buf = new StringBuilder(len);

    while (index < len) {
        char c = s.charAt(index);
        if (c == '\\') {
            if (++index < len) {
                c = s.charAt(index);
                switch (c) {
                case '0': case '1': case '2': case '3': case '4':
                case '5': case '6': case '7': case '8': case '9':
                case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
                case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
                    int numValue = Character.digit(c, 16);
                    int count = 1;
                    if (maxCount == 0) {
                        maxCount = ((ac.getCssVersion() == CssVersion.CSS1) ?
                                    4 : 6);
                    }
                    while (index + 1 < len) {
                        c = s.charAt(index+1);
                        t = Character.digit(c, 16);
                        if (t != -1 && count++ < maxCount) {
                            numValue = (numValue<<4) | t;
                            index++;
                        } else {
                            if (c == ' ' || c == '\t' ||
                                c == '\n' || c == '\f' ) {
                                // skip the latest white space
                                index++;
                            } else if ( c == '\r' ) {
                                index++;
                                // special case for \r\n
                                if (index+1 < len) {
                                    if (s.charAt(index + 1) == '\n') {
                                        index++;
                                    }
                                }
                            }
                            break;
                        }
                    }
                    if (!escapeFirst && numValue < 255 && numValue>31) {
                        if (! ( (numValue>96 && numValue<123) // [a-z]
                                || (numValue>64 && numValue<91) // [A-Z]
                                || (numValue>47 && numValue<58) // [0-9]
                                || (numValue == 95) // _
                                || (numValue == 45) // -
                                )
                            ) {
                            buf.append('\\');
                        }
                        buf.append((char) numValue);
                        break;
                    }
                    char b[] = new char[maxCount];
                    t = maxCount;
                    while (t > 0) {
                        b[--t] = hexdigits[numValue & 0xF];
                        numValue >>>= 4;
                    }
                    buf.append('\\').append(b);
                    break;
                case '\n':
                case '\f':
                    break;
                case '\r':
                    if (index + 1 < len) {
                        if (s.charAt(index + 1) == '\n') {
                            index ++;
                        }
                    }
                    break;
                case '-' : case '_' : case 'g' : case 'G' :
                case 'h' : case 'H' : case 'i' : case 'I' :
                case 'j' : case 'J' : case 'k' : case 'K' :
                case 'l' : case 'L' : case 'm' : case 'M' :
                case 'n' : case 'N' : case 'o' : case 'O' :
                case 'p' : case 'P' : case 'q' : case 'Q' :
                case 'r' : case 'R' : case 's' : case 'S' :
                case 't' : case 'T' : case 'u' : case 'U' :
                case 'v' : case 'V' : case 'w' : case 'W' :
                case 'x' : case 'X' : case 'y' : case 'Y' :
                case 'z' : case 'Z' :
                    buf.append(c);
                    break;
                default:
                    buf.append('\\').append(c);
                }
            } else {
                throw new ParseException("invalid string");
            }
        } else {
            buf.append(c);
        }
        escapeFirst = false;
        index++;
    }
    return buf.toString();
  }

  String convertIdent(String s) throws ParseException {return convertStringIndex(s, 0, s.length(), false);
  }

  String convertClassIdent(String s) throws ParseException {return convertStringIndex(s, 0, s.length(), true);
  }

  String convertString(String s) throws ParseException {return convertStringIndex(s, 0, s.length(), false);
  }

  String hexEscapeFirst(String s) throws ParseException {StringBuilder sb = new StringBuilder();
    sb.append('\\').append(Integer.toString(s.charAt(0), 16));
    char c = s.charAt(1);
    if (((c >= '0') && (c <= '9')) ||
        ((c >= 'A') && (c <= 'F')) ||
        ((c >= 'a') && (c <= 'f'))) {
        sb.append(' ');
    }
    sb.append(s.substring(1));
    return sb.toString();
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_3R_138()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_177()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_126()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_125()) return true;
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_3R_138()) return true;
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(NUMBER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(DIV)) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_3R_129()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_130()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_3R_122()) return true;
    }
    if (jj_scan_token(21)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) return true;
    }
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_scan_token(UNICODERANGE)) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_scan_token(URL)) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_179()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) return true;
    }
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(FUNCTIONATTR)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) return true;
    }
    return false;
  }

  private boolean jj_3R_128()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(FUNCTIONCALC)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) return true;
    }
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_scan_token(DIV)) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) return true;
    }
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(RPARAN)) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_scan_token(FREQ)) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(ANGLE)) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(FLEX)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_scan_token(DIMEN)) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(ABSOLUTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(SPL)) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_scan_token(RELVIEWLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(ST)) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_scan_token(RELFONTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_scan_token(RESOLUTION)) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_scan_token(FREQ)) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_139()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3R_146()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_scan_token(ANGLE)) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_scan_token(DIV)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_128()) jj_scanpos = xsp;
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_scan_token(FLEX)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) jj_scanpos = xsp;
    if (jj_scan_token(104)) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(ABSOLUTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_scan_token(RELVIEWLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_scan_token(ANY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_scan_token(RELFONTLENGTH)) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(21)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  /** Generated Token Manager. */
  public CssParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[183];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0xe00000,0xe00000,0x0,0x0,0x200000,0x200000,0x0,0xc00000,0xc00000,0x200000,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x40000000,0x200000,0x200000,0x0,0x200000,0x0,0x200000,0x0,0x200000,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x200000,0x200000,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x200000,0x18000000,0x18000000,0x18000000,0x200000,0x200000,0x200000,0x200000,0x18000000,0x40000000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x200000,0x40000000,0xa8000000,0x200000,0x200000,0xa8200000,0x18000000,0x200000,0x40000000,0x200000,0x200000,0x200000,0x0,0x0,0x200000,0x0,0xa8200000,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x3000000,0x200000,0x0,0x200000,0x3000000,0x200000,0x0,0x200000,0x200000,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x200000,0x0,0x200000,0x18000000,0x200000,0x18000000,0x58000000,0x58000000,0x18000000,0x0,0x0,0x0,0x18000000,0x200000,0x18000000,0x0,0x0,0x200000,0x0,0x200000,0x18000000,0x200000,0x200000,0x200000,0x18200000,0x200000,0x200000,0x200000,0x200000,0x18000000,0x0,0x18000000,0x0,0x200000,0x200000,0x18000000,0x200000,0x200000,0x0,0x200000,0x0,0x200000,0x40000000,0x200000,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe5d14070,0x0,0x0,0x0,0x0,0x0,0x10,0x200004,0x0,0x0,0x0,0x200004,0x0,0x80012,0x0,0x0,0x0,0xe5d14070,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x1,0x0,0x1,0x0,0x80012,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x10,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x1000,0x0,0x10,0x0,0x0,0x0,0xe5d04060,0xe5d04060,0xe5d04060,0xe5d04060,0xe5d14070,0xe5c00000,0xe5c00000,0x10010,0x10010,0x10010,0x0,0x0,0xf00,0x0,0x14,0x0,0xf00,0x0,0xe5d14070,0x0,0x0,0x14,0x0,0x0,0x0,0x10,0x100000,0x60,0x0,0x0,0x100000,0x0,0x0,0x0,0x14,0x0,0x14,0xffe0e074,0xffe00074,0x0,0xffc00000,0xc000,0x20e074,0xffe0e074,0x0,0x0,0x0,0xffc00000,0x0,0x200074,0x0,0xffe00074,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x12000,0x0,0x67c00000,0x0,0x0,0x67c80000,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x0,0x10,0x60,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x20,0x0,0x0,0x40,0x80,0x0,0x0,0x183f11,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3c000,0x3c000,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11,0x11,0x11,0x11,0x11,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x8,0x0,0x0,0x8,0x0,0x7,0x0,0x7,0x80000007,0x80000007,0x0,0x7,0x0,0x80000000,0x80000007,0x0,0x0,0x4,0x7,0x0,0x80000000,0x0,0x80000007,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x0,0x0,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0xc0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x105,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x105,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x5,0x5,0x5,0x105,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x101,0x0,0x0,0x0,0x0,0x0,0x22,0x22,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38,0x20,0x0,0x0,0x0,0x38,0x38,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x0,0x200,0x0,0x200,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[5];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public CssParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public CssParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new CssParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CssParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CssParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CssParser(CssParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CssParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[106];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 183; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 106; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 5; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
